package Zim::Formats::Pod;

use strict;
use Pod::Simple::SimpleTree;

our $VERSION = 0.01;

our %ALIASES = (
	Document  => 'Page',
	B         => 'bold',
	C         => 'verbatim',
	I         => 'italic',
	L         => 'link',
	U         => 'underline',
);
	# head1 .. headX is the same
	# Verbatim and Para are the same
	# links have objects in the "to" field
	# lists come as "over-text" grouping "item-text"
       	
# FIXME what to use for strike ??
#	bold      => 'B',
#	verbatim  => 'C',
#	italic    => 'I',
#	link      => 'L',
#	underline => 'U',

=head1 NAME

... - simple module

=head1 SYNOPSIS

FIXME simple code example

=head1 DESCRIPTION

FIXME descriptve text

=head1 EXPORT

None by default.

=head1 METHODS

=over 4

=item C<load_tree()>

=cut

sub load_tree {
	my ($class, $io, $page) = @_;
	my $parser = Pod::Simple::SimpleTree->new;
	$parser->parse_file($io);
	my $tree = $parser->root;
	#use Data::Dumper; warn Dumper $tree;
	return _transform_tree($tree);
}

sub _transform_tree {
	my $tree = shift;
	my ($type, $meta) = splice @$tree, 0, 2;
	$$meta{to} = "$$meta{to}" if $type eq 'link';
	if (exists $ALIASES{$type}) {
		return [$ALIASES{$type}, $meta, _recurs($tree)]
	}
	elsif ($type eq 'over-text') {
		return _recurs($tree);
	}
	elsif ($type eq 'item-text') {
		return "\x{2022} ", _recurs($tree), "\n\n";
		# FIXME arbitrary logic for items with paragraphs
	}
	else {
		$$meta{empty_lines} = 2 if $type =~ /^[A-Z]/;
		$$meta{empty_lines} = 1 if $type =~ /^head/;
		if ($type eq 'Verbatim') {
			if ($$tree[0] =~ /^(\s*)/) {
				my $l = length $1;
				s/^\s{0,$l}//mg for @$tree;
			}
		}
		return [$type, $meta, _recurs($tree)];
	}
}

sub _recurs {
	my $tree = shift;
	return map {
		ref($_) ? _transform_tree($_) : $_ ;
	} @$tree;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2005 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

