#!/usr/bin/perl

use lib './lib';
use Zim::FS;

# This script reads the default config values from GUI.pm
# and writes the config files ia ./share/zim .
# The default config is written to default.conf,
# __DATA__ below contains other profiles like reader.conf .
# This script is called by "./Build distmeta".

$SIG{__WARN__} = sub { print STDERR @_ unless $_[0] =~ /^#/ };

open IN, 'lib/Zim/GUI.pm' or die $!;
while (<IN>) { last if /CONFIG/ }
while (<IN>) {
	/\{/ and next;
	/\}/ and last;
	chomp;
	($k, $v) = split /\s+/, $_, 2;
	$CONFIG{$k} = $v;
}
close IN;

#use Data::Dumper;
#print Dumper \%CONFIG;

$f = Zim::FS::File::Config->new(qw/share zim default.conf/);
print "Writing $f\n";
$f->write(\%CONFIG, 'Config');

while (<DATA>) {
	if (/^%%\s*(\S+)\s*%%$/) {
		$f = Zim::FS::File::Config->new(qw/share zim/, $1);
		%config = %CONFIG;
		print "Writing $f\n";
	}
	elsif (/^(.+?)=(.*)/) {
		$config{$1} = $2;
	}
	else { $f->write(\%config, 'Config') }
}

__DATA__
%% reader.conf %%
read_only=1
plugins=

