package Zim::Utils::Win32;

use strict;
use Win32::Process;
require Cwd;

our $VERSION = '0.23';

=head1 NAME

Zim::Win32 - win32 specific routines for zim

=head1 DESCRIPTION

This module contains some routines that are specific
for the windows platform.

=cut

## Spawning processes ##

$Zim::GUI::DEFAULTS{browser} = 'firefox.exe';
$Zim::GUI::DEFAULTS{file_browser} = 'explorer.exe';
$Zim::GUI::DEFAULTS{text_editor} = 'notepad.exe';

sub run {
	my ($self, @args) = @_;
	my ($prog, $cmdline);
	if (@args > 1) {
		$cmdline = join ' ', map {/\s/ ? qq/"$_"/ : $_} @args;
		$prog = $args[0];
	}
	else {
		$cmdline = $args[0];
		$args[0] =~ /^(['"])(.+?)\1|^(\S+)/;
		$prog = $2 || $3;
	}
	$prog = _lookup_exec($self, $prog) unless $prog =~ /\\/;
	return unless $prog;
	
	warn "Executing $prog, $cmdline\n";
	my $ProcessObj;
	Win32::Process::Create(
		$ProcessObj, $prog, $cmdline, 0, NORMAL_PRIORITY_CLASS, "." );
};

sub _lookup_exec {
	my ($self, $prog) = @_;
	for (split /;/, $ENV{PATH}) {
		my $try = File::Spec->catfile($_, $prog);
		return $try if -f $try;
	}
	warn "Could not find program: $prog";
	return undef;
}

package Zim::File::Win32;

our @ISA = qw/Zim::File::Unix/;

# Turn /foo into C:/foo
# wrap unix abs_path function by using /C:/path

sub abs_path {
	my ($class, $file, $ref) = @_;
	
	if ($file =~ m#file:/#) { $file = $class->parse_uri($file) }
	else { $file =~ s#\\#/#g } # foo\bar => foo/bar
	
	$file =~ s#^([a-z]:/)#/$1#i; # C:/foo => /C:/foo
	$file = Zim::File::Unix::abs_path($class, $file, $ref);
	$file =~ s#^/+([a-z]:/)#$1#i; # /C:foo => C:/foo
	
	return $file unless $file =~ m#^/#i;

	$ref ||= Cwd::cwd();
	my ($vol, undef, undef) = File::Spec->splitpath($ref);
	return $vol.$file;
};

# support file:///C:/path
# translate file:////host/share => smb://host/share

sub parse_uri {
	my $class = shift;
	my $file = shift;
	$file =~ m#^file:/# or return $file;
	return $file if $file =~ s#^file:////(?!/)#smb://#;
	$file = Zim::File::Unix::parse_uri($class, $file);
	$file =~ s#^/+([a-z]:/)#$1#i;
	return $file;
};

sub localize {
	my $file = pop;
	if    ($file =~ s#^smb://+##) { $file = '\\\\'.$file }
	elsif ($file =~ m#^\w[\w\+\-\.]+:/#) { return $file }
	elsif ($file =~ m#^/#) {
		my $cwd = Cwd::cwd();
		my ($vol, undef, undef) = File::Spec->splitpath($cwd);
		$file = $vol.$file;
	}
	$file =~ s#/+#\\#g;
	return $file;
};

1;

__END__

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

