package Zim::Utils;

use strict;
use File::BaseDir qw/xdg_data_files/;

our $VERSION = '0.20';

eval 'use Zim::OS::Win32' if $^O eq 'MSWin32';
die $@ if $@;

our @ISA = ($^O eq 'MSWin32') ? ('Zim::Utils::Win32')
                              : ('Zim::Utils::Unix' ) ;

our $LANG = $ENV{LANG};
$LANG =~ s/\..*//; # remove char encoding

our %Translation;

sub import {
	my ($caller) = caller;
	#warn "Package $caller uses utils\n";
	no strict 'refs';
	if (_find_translation($caller)) {
		# Export the translation
		*{$caller.'::__'} =
			sub { return $Translation{$caller}{$_[0]} || $_[0] };
	}
	else {
		# Check if the module inherits a translation already
		*{$caller.'::__'} = sub { return $_[0] }
			unless $caller->can('__');
	}
}

sub _find_translation {
	# TODO: search other language variations nl_BE => nl_NL etc.
	my $package = shift;
	return 1 if $Translation{$package};
	return 0 if $LANG =~ /^en_/; # optimization - source is in English
	my @path = split /::/, $package;
	$path[-1] .= '.pl';
	my ($file) = xdg_data_files('zim', 'locale', $LANG, @path);
	return 0 unless $file;
	warn "# Loading translation from: $file\n";
	eval { $Translation{$package} = do $file };
	warn $@ if $@;
	return 1;
}

package Zim::Utils::Unix;

=head1 NAME

Zim::Utils - Some useful functions and objects for zim.

=head1 SYNOPSIS

FIXME

=head1 DESCRIPTION

FIXME

=head1 METHODS

=over 4

=item C<run(PROGRAM, ARG, ...)>

Run background process (fork + exec).

=cut

sub run {
	my ($self, @args) = @_;
	warn "Executing: @args\n";
	unless (fork) { # child process
		exec @args;
		exit 1; # just to be sure
	}
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2007 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

