package Zim::GUI::RepositoriesDialog;

use strict;
use File::BaseDir qw/xdg_config_home xdg_config_files/;
use Zim::File;
use Zim::GUI::Component;

our $VERSION = '0.20';
our @ISA = qw/Zim::GUI::Component/;

=head1 NAME

Zim::GUI::RepositoriesDialog - Chooser dialog with repositories

=head1 DESCRIPTION

FIXME descriptve text

=head1 METHODS

=over 4

=cut

sub init {
	my $self = shift;
	$self->{app} || $self;
}

=item C<show(CALLBACK)>

Constructs a new dialog.

If CALLBACK is specified it will be called to open a repository.
Else a new instance of zim is started.

=cut

sub show {
	my $self = shift;
	my $cb = shift;

	my $dialog = Gtk2::Dialog->new(
		"Open repository - Zim", undef,
	       	[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-open'   => 'ok',
	);
	#$dialog->set_type_hint('utility');
	$dialog->set_default_size(100,250);
	$dialog->set_border_width(5);
	$dialog->set_icon(
		Gtk2::Gdk::Pixbuf->new_from_file($Zim::ICON) );
			# defined in Component.pm
	$dialog->set_default_response('ok');

	unless ($self->{app}{window}) { # no parent
		$self->{on_top} = 1;
		$self->{app}{window} = $dialog;
	}
	
	$dialog->vbox->set_spacing(5);
	$dialog->vbox->pack_start(
		Gtk2::Label->new('Please choose a repository'), 0,1,0 );
	
	my $hbox = Gtk2::HBox->new(0, 12);
	$dialog->vbox->add($hbox);
	
	my $list = Gtk2::SimpleList->new('Repository' => 'text');
	$list->set_headers_visible(0);
	$list->get_selection->set_mode('browse');
	$list->signal_connect(
		row_activated => sub { $dialog->response('ok') });
	$hbox->add($list);
	
	# load list
	my ($source, $order) = ({}, []);
	my ($file) = xdg_config_files('zim', 'repositories.list');
	if (defined $file) {
		$file = Zim::File->new($file);
		($source, $order) = $file->read_config;
		@$order = grep {! /^_/} @$order;
		@{$list->{data}} = @$order;
		$self->{default} = $$source{_default_};
	}
	
	my $vbox1 = Gtk2::VBox->new(0,0);
	$hbox->pack_start($vbox1, 0,0,0);

	my $vbox = Gtk2::VButtonBox->new();
	$vbox->set_layout('start');
	$vbox1->pack_start($vbox, 0,0,0);
	
	my @buttons = map Gtk2::Button->new_from_stock($_),
		qw/gtk-add gtk-remove/;
	splice @buttons, 1, 0, $self->new_button('gtk-properties', 'Cha_nge');
	$vbox->add($_) for @buttons;
	
	my $modified = 0;
	my $modify = sub {
		my ($i, $name, $dir);
		if (pop @_) { #boolean user data
			($i) = $list->get_selected_indices;
			($name) = @{$list->{data}[$i]};
			$dir = $$source{$name};
		}
		else { $i = scalar @{$list->{data}} }
		($name, $dir) = $self->prompt_new_repository($name, $dir);
		return unless defined $name;
		$$source{$name} = $dir;
		splice @{$list->{data}}, $i, 1, $name;
		$modified = 1;
		$list->select($i);
	};
	$buttons[0]->signal_connect(clicked => $modify, 0);
	$buttons[1]->signal_connect(clicked => $modify, 1);
	$buttons[2]->signal_connect(clicked => sub {
			my ($i) = $list->get_selected_indices;
			splice @{$list->{data}}, $i, 1;
			$modified = 1;
		} );
	
	my $default_button = $self->new_button('gtk-home', 'Set _Default');
	$vbox1->pack_end($default_button, 0,0,0);
	$default_button->signal_connect(
			clicked => sub {$self->prompt_default; $modified = 1} );

	$dialog->signal_connect(response => sub {
		my ($dialog, $response) = @_;
		
		# Save list
		if ($modified) {
			@$order = ('_default_', map $$_[0], @{$list->{data}});
			$$source{_default_} = $self->{default};
			$file = Zim::File->new(
				xdg_config_home, 'zim', 'repositories.list' );
			$file->write_config($source, $order);
		}

		if ($response eq 'help') {
			return $self->ShowHelp('zim:usage:repositories');
		}
		elsif ($response ne 'ok') {
			$dialog->destroy;
			Gtk2->main_quit if $self->{on_top};
			return;
		}

		my ($i) = (@{$list->{data}} == 1)
			? (0) : ($list->get_selected_indices);
		return $self->error_dialog("Please select a repository first.\n")
			unless defined $i;
	
		my ($name) = @{$list->{data}[$i]};
		my $src = Zim::File->abs_path($$source{$name}, $ENV{HOME});
		if ($cb) { $cb->($name, $src)                            }
		else     { $self->exec_new_window('--name', $name, $src) }
		$dialog->destroy;
	} );
	
	$dialog->show_all;
}

=item C<prompt_new_repository(NAME, DIR)>

=cut

sub prompt_new_repository {
	my $self = shift;
	my $val = $self->run_prompt(
		'New repository - Zim',
		['name', 'dir'], {
			name => ['Name', 'string', $_[0]],
			dir  => ['Directory', 'dir', $_[1]],
		}, undef, undef,
		"<i>Please give a directory to store your pages.\nFor a new repository this should be an empty directory.\nFor example a \"Notes\" directory in your home dir.</i>" )
		or return undef;
	
	my ($name, $dir) = @$val;
	return undef unless $dir =~ /\S/;
	$name = $dir unless $name =~ /\S/;
	
	return ($name, $dir);
}

=item C<prompt_default()>

Ask for default repository.

=cut

sub prompt_default {
	my $self = shift;
	my $val = $self->run_prompt(
		'Set default repository',
		['root'], {
			root => ['Repository', 'repository', $self->{default}]
		}, undef, undef,
		"<i>Please select a default repository here</i>" )
		or return undef;
	$self->{default} = $$val[0];
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2007 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

