#!/usr/bin/perl

use strict;
use lib './lib';
use Zim::File;

print "Creating test repository\n";

$SIG{__WARN__} = sub { print STDERR @_ unless $_[0] =~ /^#/ };

my ($file, $fh);
binmode DATA, ':utf8' if not $] < 5.008;
while (<DATA>) {
	if (/^%%\t(\S+)\t%%$/) {
		$fh->close if $fh;
		$file = Zim::File->new($1);
		$file->make_dir;
		$fh = $file->open('w');
	}
	elsif ($fh) {
		print $fh $_;
	}
	else { die "oops" }
}
$fh->close if $fh;

__DATA__
%%	t/repository/Test/wiki.txt	%%
====== Foo Bar ======

This is a **test page** to see how parsing goes
when ''we'' ''loop'',
arbitrary //content// through our __parser__

($ROOT, $PAGE, @BACK, @FORW, $UNDO, $REDO);
		my (%tree_iter, $tree_loaded, $pane_visible);
		my (@undo_chars, $undo_lock, $save_lock, $overwrite_toggle);
		my %undo_steps = (
	       delete => 'insert', insert => 'delete',
	       apply_tag => 'remove_tag', remove_tag => 'apply_tag' );
		my $link_icon = Gtk2->CHECK_VERSION(2, 6, 0) ? 'gtk-connect' : 'gtk-convert';
	       # gtk-connect stock item was introduced in 2.6.0
		my $DATA_DIR  = find_data_dir();
		my $ICON_FILE = File::Spec->catfile($DATA_DIR, qw/images zim64.png/);

my %opts = ( 'read_only' => 0 );
	for (@ARGV) {
	        next unless /^-/;
	        if (/^(--version|-v)$/) {
	                print version();
	                exit;
	        }
	        elsif (/^--read-?o
	             my $iter = $buffer->get_iter_at_mark($buffer->get_insert());
	                return parse_backspace($iter);
	        }
	        elsif ($val == $k_tab or $val == ord(' ')) { # Other WhiteSpace
	                my $buffer = $self->get_buffer;
	                my $iter = $buffer->get_iter_at_mark($buffer->get_insert());
	                my $string = ($val == $k_tab) ? "\t" : ' ';
	                return parse_word($iter, $string);
	        }
	        #else { printf "key %x pressed\n", $val } # perldoc -m Gtk2::Gdk::Keysyms

return 0; } )
unless $opts{read_only};

Glib::Timeout->add(5000, \&save_page)
	        unless $opts{read_only}; # TODO also use this timer for maintaining an undo stack

	# ################# # 


	some pre format
	dsfdf
			dfssdf
			sdfsdf

	sdf
	sdf
		*&^*&%*&

===== So =====
what do we need to type
* to make
	* the parser
	* vomit
		* ???

OK, maybe a heading
==== Hmmm ====
sandwhich might do that ?

dfsfds
sdfd
fdsfdsfdsfds


{{foo.png}}{{bar.png}}


fsdfds

=== fdsfds ===

123 test

sdffdsfds
%%	t/repository/Test/foo/bar.txt	%%
= FOO =

[[wIKi]]

•• Search Me ••

%%	t/repository/Test/foo.txt	%%
====== Foo ======

bar baz

