use Test::More tests => 5;

use Zim::File;
use Zim;
use Zim::Selection;
use strict;

$SIG{__WARN__} = sub {
	print STDERR @_ unless $_[0] =~ /^#|Exporting|Indexing/;
};

my $root = File::Spec->rel2abs( File::Spec->catdir(qw/t repository/) );
my $rep = Zim->new(dir => $root);

my $file = Zim::File->new($root, qw/.. html Test wiki.html/);
$file->remove if $file->exists;
die "File already exists: $file" if $file->exists;

my $selection = Zim::Selection->new($rep, {}, ':Test:wiki');
$selection->export( {
	dir => "$root/../html",
	format => 'html',
	media => 'absolute',
} );

ok($file->exists, 'Exported file exists');
ok($file->read =~ m#This is a <b>test page</b> to see how parsing goes<br />#, 'File has html content');

$file->remove if $file->exists;
die "File already exists: $file" if $file->exists;

SKIP: {
	system('./bin/zim', '--version') == 0
		or skip('Executing ./bin/zim failed !?', 3);
	my $r = system('./bin/zim', '--export', 'dir=./t/html,format=html', './t/repository');
	ok($r == 0, 'command line export');
	ok($file->exists, 'Exported file exists');
	ok($file->read =~ m#This is a <b>test page</b> to see how parsing goes<br />#, 'File has html content');
}

