package Zim::GUI::PropertiesDialog;

use strict;
use File::BaseDir qw/xdg_data_files xdg_data_dirs xdg_data_home/;
use Gtk2;

our $VERSION = '0.18';

=head1 NAME

Zim::GUI::PropertiesDialog - dialog for zim

=head1 DESCRIPTION

This module contains the preferences dialog for zim.
It is autoloaded when needed.

=head1 METHODS

=over 4

=item C<new()>

Simple constructor

=cut

sub new {
	my ($class, %self) = @_;
	bless \%self, $class;
}

=item C<show()>

Present the dialog.

=cut

sub show {
	my $self = shift;
	my $app = $self->{app};
	my $settings = $self->{app}{settings};
	
	my $dialog = Gtk2::Dialog->new(
		"Properties - Zim", $app->{window},
	       	[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-ok'     => 'ok',
	);
	$dialog->set_resizable(0);
	
	my $tabs = Gtk2::Notebook->new;
	$dialog->vbox->add($tabs);
	
	## Repository tab
	my $vbox1 = Gtk2::VBox->new(0,5);
	$vbox1->set_border_width(5);
	$tabs->append_page($vbox1, 'Repository');
	
	my @keys = qw/name icon home/;
	my @labels = (
		'Name',
		'Icon',
		'Home Page',
	);
	my %entries;
	my $table = Gtk2::Table->new(scalar(@labels)+1, 3);
	$table->set_row_spacings(5);
	$table->set_col_spacings(12);
	$vbox1->pack_start($table,0,1,0);
	for (0 .. $#keys) {
		my $label = Gtk2::Label->new($labels[$_].':');
		my $align = Gtk2::Alignment->new(0,0.5, 0,0);
		$align->add($label);
		$table->attach_defaults($align, 0,1, $_,$_+1);
		my $entry = Gtk2::Entry->new;
		$table->attach_defaults($entry, 1,2, $_,$_+1);
		$entries{$keys[$_]} = $entry;

		if ($keys[$_] eq 'icon') {
			my $button = Gtk2::Button->new('_Browse...');
			$button->signal_connect(clicked => sub {
				my $f = $self->{app}->filechooser_dialog();
				$f = Zim::File->rel_path(
					$f, $self->{app}{repository}{dir})
					|| $f;
				$entry->set_text($f);
			} );
			$table->attach_defaults($button, 2,3, $_,$_+1);
		}
	}
	
	my $config = $self->{app}{repository}->config;
	$entries{$_}->set_text($$config{$_}) for @keys;

	## Show it all
	$dialog->show_all;
	while ($_ = $dialog->run) {
		if ($_ eq 'help') {
			$app->ShowHelp(':zim:usage:properties');
			next;
		}
		last unless $_ eq 'ok';
		
		for (@keys) {
			my $string = $entries{$_}->get_text;
			$$config{$_} = $string;
		}
		$self->{app}{repository}->save_config;
		$self->{app}->set_home($$config{home})
			if defined $$config{home};

		last;
	}
	$dialog->destroy;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

