use Test::Simple tests => 7;

use Gtk2::Ex::FormManager;

my $fm = Gtk2::Ex::FormManager->new();
$fm->add_fields(
	# name, label, type, default, test
	['test', 'Test', 'int',  1, 1],
	['ok',   'Ok',   'bool', 1, 1],
);

my $hash = $fm->get_hash;

ok tied(%$hash), 'Hash is tied'; #1
ok $$hash{test} == 1, 'Default 1'; #2
ok $$hash{ok} == 1, 'Default 2'; #3

$$hash{test} = 5;
ok $$hash{test} == 5, 'Set value int'; #4

eval { $$hash{test} = 'string' };
#warn $@;
ok length($@), 'Type checking int'; # 5
ok $$hash{test} == 5, 'Type checking int'; #6

my $dus;
$fm->signal_connect(set_test => sub { $dus = $_[1] });
$$hash{test} = 42;
ok $dus == 42, 'Signal handler'; #7

