use Test::Simple tests => 7;

use Zim::Repository::Files;
use File::Spec;

eval 'require Zim::Win32' if $^O eq 'MSWin32';
die $@ if $@;

$Zim::CODESET = 'utf8';

my $dir = File::Spec->rel2abs( File::Spec->catdir(qw/t repository/) );
my $rep = Zim::Repository::Files->new(undef, '', $dir);

ok($rep->{format} eq 'wiki'); # 1

ok($rep->file('foo:bar')->path =~ m#/t/repository/foo/bar.txt$#,
	'filename 1' ); # 2

my $page = $rep->get_page(':foo:bar');
ok($page->status eq 'new', 'status new page'); # 3
ok(@{$page->get_parse_tree} > 2, 'template'); # 4 
ok($page->{format} eq 'Zim::Formats::Wiki', 'format'); # 5

ok($rep->file('Test:wiki')->path =~ m#/t/repository/Test_files/wiki.txt$#,
	'filename 2' ); # 6

ok($rep->resolve_page('test:WIKI')->name eq ':Test:wiki', 'resolve_page'); # 7

#$page = $rep->open_page('test:utf8-acchars');

