use Test::More tests => 24;

use File::BaseDir qw/xdg_data_dirs/;
$ENV{XDG_DATA_DIRS} = join ':', 'share', xdg_data_dirs;

for my $class (qw/
	Zim::File
	Zim::Formats::Wiki
	Zim::Formats::Pod
	Zim::Formats::Html
	Zim::Page
	Zim::Page::Text
	Zim::History
	Zim::Repository
	Zim::Repository::Base
	Zim::Repository::Files
	Zim::Repository::Man
	Gtk2::Ex::PathBar
	Gtk2::Ex::HyperTextView
	Gtk2::Ex::HyperTextBuffer
	Gtk2::Ex::FormManager
	Zim::GUI::PageView
	Zim::GUI::TreeView
	Zim::GUI::PathBar
	Zim::GUI::Calendar
	Zim::GUI::SearchDialog
	Zim::GUI::FindReplaceDialog
	Zim::GUI
/) {
	use_ok($class);
}

SKIP: {
	skip "use Win32 module", 1 unless $^O eq 'MSWin32';
	use_ok('Zim::Win32');
};

SKIP: {
	eval 'use File::MimeInfo::Applications';
	skip('No File::MimeInfo::Applications available') if $@;
	use_ok('Gtk2::Ex::DesktopEntryMenu');
};

