use strict;
use File::Spec;
use Zim::File;
use Zim::Page;
use Zim::Repository::Files;

# Plugin for temporary Printing Fix
# Some methods used are considered unstable API
# Your mileage may vary

my $app  = Zim::GUI->current;

$app->{actions}->add_actions( [
	[	'TmpPrint',
		'gtk-print',
		'Print to Browser',
		'<Ctrl>P',
		'Print to browser',
		\&on_TmpPrint,
	],
] );
$app->{ui}->add_ui_from_string( q{
<ui>
	<menubar name='MenuBar'>
		<menu action='FileMenu'>
			<placeholder name='PrintActions'>
				<menuitem action='TmpPrint'/>
			</placeholder>
		</menu>
	</menubar>
</ui> } );

sub on_TmpPrint {
	warn "No real printing, tmp solution\n";
	my $tmpdir = File::Spec->tmpdir;

	# write template
	open TEMPLATE, ">$tmpdir/zim_template.html" or die $!;
	print TEMPLATE << 'EOF' ;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name='Generator' content='Zim [% ZIM_VERSION %]'>
	<title>[% TITLE %]</title>
	<style type='text/css'>
		a          { text-decoration: none      }
		a:hover    { text-decoration: underline }
		a:active   { text-decoration: underline }
		strike     { color: grey                }
		u          { text-decoration: none;
		             background-color: yellow   }
		pre        { margin-left: 40px          }
	</style>
</head>
<body>

<h1>[% TITLE %]</h1>

[% BODY %]

</body>
</html>
EOF
	close TEMPLATE;
	
	# Export page to html
	my $exporter = Zim::Repository::Files->new(':', $tmpdir);
	$exporter->{_template} =  "$tmpdir/zim_template.html";
	$exporter->{_abs_image_paths}  = 1;
	my ($rep, $page) = @{$app}{'repository', 'page'};
	my $tmp = Zim::Page::Text->new($exporter, $page->name);
	$tmp->set_source( Zim::File->new("$tmpdir/zim_page.html") );
	$tmp->set_format('html');
	$tmp->properties->{base} = $page->properties->{base};
	$tmp->clone($page);
	warn "Exported to $tmpdir/zim_page.html\n";

	# Exec Browser
	my $link = "$tmpdir/zim_page.html";
	my $browser = $app->{settings}{'browser'} || $ENV{BROWSER};
	$browser =~ s/\%s/$link/ or $browser .= ' '.$link;
	$app->_exec($browser);
}
