package Zim::GUI::FindReplaceDialog;

use strict;
use Gtk2;

our $VERSION = '0.16';

=head1 NAME

Zim::GUI::FindReplaceDialog - simple module

=head1 SYNOPSIS

FIXME simple code example

=head1 DESCRIPTION

FIXME descriptve text

=head1 EXPORT

None by default.

=head1 METHODS

=over 4

=item C<new()>

Simple constructor

=cut

sub new {
	my ($class, %self) = @_;
	bless \%self, $class;
}

=item C<show()>

=cut

sub show {
	my $self = shift;
	my $query = shift;
	
	if (defined $self->{dialog}) {
		$self->{dialog}->present;
		# FIXME do something wit $query
		return;
	}
	
	## Setup dialog
	my $dialog = Gtk2::Dialog->new(
		'Find and Replace - Zim', $self->{app}{window},
		[qw/destroy-with-parent no-separator/],
		'gtk-help'  => 'help',
		'gtk-close' => 'close',
	);
	$dialog->set_resizable(0);
	$dialog->set_border_width(5);
#	$dialog->set_default_size(1,275);
	$dialog->set_icon($self->{app}{window}->get_icon);
	
	my $hbox = Gtk2::HBox->new(0,12);
	$hbox->set_border_width(12);
	$dialog->vbox->add($hbox);

	my $vbox = Gtk2::VBox->new(0,5);
	$hbox->pack_start($vbox, 0,1,0);

	# Entries
	my $align = Gtk2::Alignment->new(0,0.5, 0,0);
	$align->add( Gtk2::Label->new('Find what:') );
	$vbox->add( $align );
	my $find_entry = Gtk2::Entry->new;
	$vbox->add( $find_entry );

	$align = Gtk2::Alignment->new(0,0.5, 0,0);
	$align->add( Gtk2::Label->new('Replace with:') );
	$vbox->add( $align );
	my $replace_entry = Gtk2::Entry->new;
	$vbox->add( $replace_entry );

	# Buttons
	my $direction = 1; # go forward by default
	my $bbox = Gtk2::VButtonBox->new;
	$hbox->add($bbox);
	
	my $next_b = $self->{app}->new_button('gtk-go-forward', '_Next');
	$next_b->signal_connect(clicked => sub {
		my $query = $find_entry->get_text;
		$direction = 1;
		$self->{app}->PageView->search($query, $direction);
	} );
	$find_entry->signal_connect( activate => sub { $next_b->clicked } );
	$bbox->add($next_b);

	my $prev_b = $self->{app}->new_button('gtk-go-back', '_Previous');
	$prev_b->signal_connect(clicked => sub {
		my $query = $find_entry->get_text;
		$direction = -1;
		$self->{app}->PageView->search($query, $direction);
	} );
	$bbox->add($prev_b);

	my $repl_b = $self->{app}->new_button('gtk-find-and-replace', '_Replace');
	$repl_b->signal_connect(clicked => sub {
		my $query = $find_entry->get_text;
		my $string = $replace_entry->get_text;
		$self->{app}->PageView->replace($string);
		$self->{app}->PageView->search($query, $direction);
	} );
	$bbox->add($repl_b);

	my $repl_all_b = Gtk2::Button->new('Replace _all');
	$repl_all_b->signal_connect(clicked => sub {
		my $query = $find_entry->get_text;
		my $string = $replace_entry->get_text;
		$self->{app}->PageView->replace_all($query => $string);
	} );
	$bbox->add($repl_all_b);
	
	$dialog->signal_connect(response => sub {
		my ($dialog, $response) = @_;
		if ($response eq 'help') {
			$self->{app}->show_help('zim:usage:searching');
		}
		else { $self->hide }
	} );

	$self->{dialog} = $dialog;
	$dialog->show_all;
	$dialog->move( @{$self->{position}} ) if $self->{position};
	
	if (length $query) {
		$find_entry->set_text($query);
		# TODO find text
	}
}

=item C<hide()>

=cut

sub hide {
	return unless $_[0]->{dialog};
	$_[0]->{position} = [ $_[0]->{dialog}->get_position ];
	$_[0]->{dialog}->destroy;
	$_[0]->{dialog} = undef;
}

=item C<search(QUERY)>

=cut

sub search {
	my $self = shift;
	$self->show(@_);
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

