use Test::More tests => 2;
use Gtk2::Ex::HyperTextBuffer;

my $buffer = Gtk2::Ex::HyperTextBuffer->new();
$buffer->create_default_tags;

$buffer->set_parse_tree(&tree1);
is_deeply(
	$buffer->get_parse_tree(),
	&tree1,
	'parse tree round trip' ); # 1

$buffer->set_parse_tree(&tree2);
is_deeply(
	$buffer->get_parse_tree(),
	&tree2,
	'parse tree with image' ); # 2

sub tree1 {
	['Document', {},
		['head1', {empty_lines => 1}, 'Test page'],
		"This is a test page showing some syntax:\n\n",
		['bold', {}, 'Bold text'], "\n",
		['italic', {}, 'Italic text'], "\n",
		['bold', {},
			'more bold and ',
			['italic', {}, 'Bold and Italic']
		], "\n",
	]
}

sub tree2 {
	['Document', {},
		['head1', {empty_lines => 2}, 'Test page'],
		"This is a test page showing some syntax:\n\n",
		['bold', {}, 'Bold text'], "\n",
		['italic', {}, 'Italic text'], "\n",
		['image', {src => './share/pixmaps/zim/zim.png'}],
		['bold', {},
			'more bold and ',
			['italic', {}, 'Bold and Italic']
		], "\n",
	]
}
