package Gtk2::Ex::FormManager;

use strict;
use Gtk2;

our $VERSION = '0.01';

=head1 NAME

Gtk2::Ex::FormManager - Autogenerate input forms

=head1 SYNOPSIS

	use Gtk2;
	use Gtk2::Ex::FormManager;

	my $fm = Gtk2::Ex::FormManager->new();
	
	$fm->add_fields(
		# name, label, type, default, test
		['name', 'Name',   'string', '',      1],
		['src',  'Source', 'file',   '',      1],
		['type', 'Type',   'string', 'Image', 0],
	);
	$fm->add_ui(q{
	<form name='new_object'>
		<label field='type'/>
		<input field='name'/>
		<input field='src'/>
	</form>
	});
	
	my $widget = $fm->get_widget('new_object');
	my $values = $fm->get_hash(); # hash is tied!

=head1 DESCRIPTION

FIXME descriptve text

=head1 FIELDS

Fields are array references describing one input field.
The array contains:

=over 4

=item name

The name of this field. This is also the hash key to find the value
for this input.

=item label

Visible name of this field.

=item type

Type of the input field. Valid types are 'string', 'int', 'bool' and 'file'.

=item default

Default value for this input. The hash will be initialised with this value.

=item test

If undefined any value is excepted and empty values translated to C<undef>.

If set to C<0> any value is excepted but empty values are translated to
C<0> for 'int' or empty string 'string'.

If set to C<1> this input always needs to have a value. It is not allowed
to set it to empty string or C<undef>. When a default is given empty
values are replaced with the default.

For type is 'string' you can specify a reference to a regex.

If the test is a code reference this code will be excuted when the value
of the input has changed. The return value should be C<1> to accept the
new value.

=back

=head1 UI

The visual layout of forms construced by this manager is controlled by
one or more pieces of xml.

Elements used:

=over 4

=item form

Toplevel element to group a set of inputs.

=item input

Input field. Type of widget depends on the type of the field represented
by this element.

=item label

Displays the value of a field. This can regarded as a non-editable input.

TODO - this element is not yet implemented

=back

=head1 METHODS

=over 4

=item C<new()>

Simple constructor.

=cut

sub new {
	my $class = shift;
	bless {
		fields => [], # field specs
		ui     => [], # ui structure
		hash   => {}, # values
	}, $class;
}

=item C<add_fields(FIELD1, FIELD1, ..)>

Add a set input fields.
This method returns an id that can be used for C<remove_fields()>.

=cut

sub add_fields {
	my $self = shift;
	push @{$self->{fields}}, @_;
	return 1;
}

=item C<remove_fields(ID)>

TODO

=cut

sub remove_fields { die 'TODO' }

=item C<add_ui(STRING)>

Add a xml layout.
This method returns an id that can be used for C<remove_ui()>.

=cut

sub add_ui {
	my ($self, $xml) = @_;

	# Parse xml
	# FIXME

	return 1;
}

=item C<remove_ui(ID)>

TODO

=cut

sub remove_ui { die 'TODO' }

=item C<get_toplevels()>

Returns a list with toplevel ui elements.

=cut

sub get_toplevels {
	my $self = shift;
	# FIXME
}

=item C<get_widget(TOPLEVEL)>

=cut

# How should widgets handle invalid input ??
# should they die or reset silently ?

sub get_widget {
	my ($self, $form) = @_;
	# FIXME translate ui structure in proxies
}

=item C<get_hash()>

=cut

sub get_hash { $_[0]->{hash} }

=item C<set_sensitive(FIELD, 0|1)>

TODO

=cut

# needs a back reference to proxies
# add signal to proxies to make them disconnect properly

sub set_sensitive { die 'TODO' }

package Gtk2::Ex::FormManager::Hash;

use strict;

=back

=head1 HASH

The tied hash contains the actual values for all input fields.
This hash is tied and will throw an exception if you try to
store an invalid value into it. This hash is updated automaticly
by the widgets that are generated by the Form Manager.

=cut

1;

__END__

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

