package Zim::Components::SearchPane;

use strict;
use Gtk2;

our $VERSION = '0.01';

=head1 NAME

Zim::Components::SearchPane - Side pane widget for zim

=head1 DESCRIPTION

This module contains a widget to add to the side pane in zim.
It gives the user a way to search through multiple documents.

=head1 METHODS

=over 4

=item C<new(app => PARENT)>

Simple constructor.

=item C<init()>

Method called by the constructor.

=cut

sub new {
	my $class = shift;
	my $self = bless {@_}, $class;
	$self->init();
	return $self;
}

sub init {
	my $self = shift;

	my $vbox = Gtk2::VBox->new(0, 0);
	$self->{vbox} = $vbox;

	$vbox->add(
		Gtk2::Label->new('Search: ') );
}

=item C<widget()>

Returns the top level widget.

=cut

sub widget { return $_[0]->{vbox} }


1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

