package Gtk2::Ex::OpenWith;

use strict;
use Gtk2;
use File::MimeInfo::Applications;

our $VERSION = '0.01';

=head1 NAME

Gtk2::Ex::OpenWith - Let the user choose an application

=head1 SYNOPSIS

	sub on_populate_popup {
		# ...
		Gtk2::Ex::OpenWith->populate_menu($menu, $hyperlink)
			if $hyperlink =~ m#^file://# ;
		# ..
	}

=head1 DESCRIPTION

This module offers an "open with" menu and a simple editor dialog
to allow users to open a file with an application that can handle it.

This is a GUI wrapper for C<File::MimeInfo::Applications>.

=head1 METHODS

=over 4

=item C<populate_menu(MENU, FILE, MIMETYPE)>

Adds "open" and "open with" items to the popup menu.
MENU should be of class L<Gtk2::Menu>.
MIMETYPE is optional and FILE can be a filename or 
an array reference containing multiple files.

=cut

sub populate_menu {
	my ($class, $menu, $file, $mimetype) = @_;
	$file =~ s#^file://+##;
	
	my $openwith = Gtk2::MenuItem->new('Open with');
	$openwith->show;
	$menu->prepend($openwith);

	my $open = Gtk2::MenuItem->new('_Open');
	$open->show;
	$menu->prepend($open);
}

=item C<openwith_menu(FILE, MIMETYPE)>

Returns a L<Gtk2::Menu> object representing the "open with" menu.
MIMETYPE is optional and FILE can be a filename or 
an array reference containing multiple files.

The "open" items tries to open the file with the default application.
It opens the dialog if no default was set.

The "open with" submenu contains all applications that think they can open
this file and an item called "other" that open the dialog.

=cut

sub openwith_menu {
	my ($class, $file, $mimetype) = @_;
	$file =~ s#^file://+##;
}

=item C<openwith_dialog(MIMETYPE)>

Returns a L<Gtk2::Dialog> object that allows the user to set a default
application for this mimetype.

=cut

# TODO add code to set a default "script" in F:M:A

sub openwith_dialog {
	my ($class, $mimetype) = @_;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

