use Test::Simple tests => 7;

use Zim::Repository;
use File::Spec;

my $dir = File::Spec->rel2abs( File::Spec->catdir(qw/t repository/) );
my $rep = Zim::Repository->new('', $dir);

ok($rep->{format} eq 'wiki');


ok($rep->filename('foo:bar') eq File::Spec->catfile($dir, qw/foo bar.txt/),
	'filename 1' );

my $page = $rep->open_page('foo:bar');
ok($page->status eq 'new', 'status new page');
ok(@{$page->get_parse_tree} > 2, 'template');
ok($page->{format} eq 'Zim::Formats::Wiki', 'format');

ok($rep->filename('Test:wiki') eq File::Spec->catfile($dir, qw/Test_files wiki.txt/),
	'filename 2' );

ok($rep->resolve_page('test:WIKI') eq ':Test:wiki', 'resolve_page');

#$page = $rep->open_page('test:utf8-acchars');

