package Zim::Formats::Html;

use strict;

our $VERSION = '0.10';

=head1 NAME

Zim::Formats::Html - Html dumper for zim

=head1 DESCRIPTION

This is a dumper that can be used to export zim wiki pages to html.

=head1 METHODS

=over 4

=item C<save_tree(IO, TREE, PAGE)>

Converts a parse tree into plain text.

=cut

# TODO avoid reading the template for ech page, cache it somewhere

sub save_tree {
	my ($class, $io, $tree, $page) = @_;

	my $template = $page->{repository}{_template};
	my ($head, $foot) = split /\%\%CONTENT\%\%/, _read_file($template), 2;
	
	my $old_fh = select $io;
	eval {
		print $head;
		_dump_node($tree, $page);
		print $foot;
	};
	select $old_fh;
	die $@ if $@;
}

sub _dump_node {
	my ($node, $page) = @_;
	my ($name, $opt) = splice @$node, 0, 2;
	
	my @tags;
	if ($name =~ /^head(\d+)/) { @tags = ("<h$1>", "</h$1>\n") }
	elsif ($name eq 'Para') {
		@tags = ("<p>\n", "</p>\n");
		if (! ref $$node[0] and $$node[0] =~ /^\s*\*\s+/m) {
			# ugly hack ... should not be necessary
			parse_list($page, @$node);
			@$node = ();
		}
	}
	elsif ($name eq 'Verbatim') {
		@tags = ("<blockquote>\n<pre>\n", "</pre>\n</blockquote>\n")
	}
	elsif ($name eq 'bold'     ) { @tags = ('<b>', '</b>')   }
	elsif ($name eq 'italic'   ) { @tags = ('<i>', '</i>')   }
	elsif ($name eq 'underline') { @tags = ('<u>', '</u>')   }
	elsif ($name eq 'verbatim' ) { @tags = ('<tt>', '</tt>') }
	elsif ($name eq 'link') {
		my $href = $$opt{to};
		unless ($href =~ m#^(\w+://|mailto:)#) {
			$href = $page->resolve_link($$opt{to});
			$href =~ s#^:*#:#;
			my $namespace = $page->namespace;
			$href =~ s#^$namespace:*##;
			$href =~ s#:+#/#g;
			$href .= '.html';
		}
		print STDERR "  link: $$opt{to} => $href\n";
		@tags = ("<a href='$href'>", "</a>");
	}	

	print $tags[0];
	for (@$node) {
		if (ref $_) { _dump_node($_, $page) } # recurse
		else {
			$_ =~ s/([^-\n\t !\#\$\%\(\)\*\+,\.\~\/\:\;=\?\@\[\\\]\^_\`\{\|\}abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789])/'&#'.(ord($1)).';'/eg; # RegEx copy pasted from Pod::Simple::Html
			print $_;
		}
	}
	print $tags[1];
}

sub parse_list { # FIXME totally wrong level for this kind of parsing :(
	my ($page, @nodes) = @_;
	
	print "<ul>\n";
	my ($level, $close);
	for (@nodes) {
		if (ref $_) { _dump_node($_, $page) }
		else {
			$_ =~ s/([^-\n\t !\#\$\%\(\)\*\+,\.\~\/\:\;=\?\@\[\\\]\^_\`\{\|\}abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789])/'&#'.(ord($1)).';'/eg; # RegEx copy pasted from Pod::Simple::Html
			my @lines = split /[\n\r]+/, $_;
			for (@lines) {
				if ($_ =~ s/^(\s*)\*\s+//) {
					print $close;
					my $lvl = length $1;
					if ($lvl > $level) {
						print "<ul>\n" for 1 .. $lvl - $level;
					}
					elsif ($lvl < $level) {
						print "</ul>\n" for 1 .. $level - $lvl;
					}
					$level = $lvl;
					print "<li>".$_;
					$close = "</li>\n";
				}
				else { print $_ }
			}
		}
	}
	print $close;
	print "</ul>\n" for 1 .. $level + 1;
}

sub _read_file {
	my $file = shift;
	open FILE, "<$file" or die "Could not read file: $file";
	my $text = join '', <FILE>;
	close FILE;
	return $text;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2005 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

