package Zim::Formats::Html;

use strict;

our $VERSION = 0.02;

=head1 NAME

Zim::Formats::Html - Html dumper for zim

=head1 SYNOPSIS

FIXME simple code example

=head1 DESCRIPTION

This is a dumper that can be used to export zim wiki pages to html.

=head1 METHODS

=over 4

=item C<save_tree(TREE, PAGE)>

Converts a parse tree into plain text.

=cut

# WARNING: the api for exporting is not yet stable
#          do not use this as a reference implementation .. yet

# TODO avoid reading the template for ech page, cache it somewhere

sub _extension { 'html' }

sub save_tree {
	my ($class, $tree, $page) = @_;

	my $text = _dump_node($tree, $page);
	
	my $template = $page->{repository}{_template};
	$template = _read_file($template);
	$template =~ s/\%\%CONTENT\%\%/$text/;
	return $template;
}

sub _dump_node {
	my ($node, $page) = @_;
	my ($name, $opt) = splice @$node, 0, 2;
	
	my ($text, @tags);
	if ($name =~ /^head(\d+)/) { @tags = ("<h$1>", "</h$1>\n") }
	elsif ($name eq 'Para') {
		@tags = ("<p>\n", "</p>\n");
		if (! ref $$node[0] and $$node[0] =~ /^\s*\*\s+/m) {
			$text = parse_list($page, @$node);
			@$node = ();
		}
	}
	elsif ($name eq 'Verbatim') {
		@tags = ("<blockquote>\n<pre>\n", "</pre>\n</blockquote>\n")
	}
	elsif ($name eq 'bold'     ) { @tags = ('<b>', '</b>')   }
	elsif ($name eq 'italic'   ) { @tags = ('<i>', '</i>')   }
	elsif ($name eq 'underline') { @tags = ('<u>', '</u>')   }
	elsif ($name eq 'verbatim' ) { @tags = ('<tt>', '</tt>') }
	elsif ($name eq 'link') {
		my $href = $$opt{to};
		unless ($href =~ m#^(\w+://|mailto:)#) {
			$href = $page->resolve_link($$opt{to});
			$href =~ s#^:*#:#;
			my $namespace = $page->namespace;
			$href =~ s#^$namespace:*##;
			$href =~ s#:+#/#g;
			$href .= '.html';
		}
		print "  link: $$opt{to} => $href\n";
		@tags = ("<a href='$href'>", "</a>");
	}	

	for (@$node) {
		if (ref $_) { $text .= _dump_node($_, $page) } # recurse
		else {
			$_ =~ s/([^-\n\t !\#\$\%\(\)\*\+,\.\~\/\:\;=\?\@\[\\\]\^_\`\{\|\}abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789])/'&#'.(ord($1)).';'/eg; # RegEx copy pasted from Pod::Simple::Html
			$text .= $_;
		}
	}
	return $tags[0].$text.$tags[1];
}

sub parse_list { # FIXME totally wrong level for this kind of parsing :(
	my ($page, @nodes) = @_;
	
	my ($text, $level, $close);
	for (@nodes) {
		if (ref $_) { $text .= _dump_node($_, $page) }
		else {
			$_ =~ s/([^-\n\t !\#\$\%\(\)\*\+,\.\~\/\:\;=\?\@\[\\\]\^_\`\{\|\}abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789])/'&#'.(ord($1)).';'/eg; # RegEx copy pasted from Pod::Simple::Html
			my @lines = split /[\n\r]+/, $_;
			for (@lines) {
				if ($_ =~ s/^(\s*)\*\s+//) {
					$text .= $close;
					my $lvl = length $1;
					if ($lvl > $level) {
						$text .= "<ul>\n" for 1 .. $lvl - $level;
					}
					elsif ($lvl < $level) {
						$text .= "</ul>\n" for 1 .. $level - $lvl;
					}
					$level = $lvl;
					$text  .= "<li>".$_;
					$close = "</li>\n";
				}
				else { $text .= $_ }
			}
		}
	}
	$text .= $close;
	$text .= "</ul>\n" for 1 .. $level;
	
	return "<ul>\n$text</ul>\n";
}

sub _read_file {
	my $file = shift;
	open FILE, "<$file" or die "Could not read file: $file";
	my $text = join '', <FILE>;
	close FILE;
	return $text;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2005 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

