use Test::More tests => 1;
use Gtk2::Ex::HyperTextBuffer;

my $tree = tree();

my $buffer = Gtk2::Ex::HyperTextBuffer->new();

$buffer->set_parse_tree($tree);

is_deeply(
	$buffer->get_parse_tree(),
	tree(),
	'parse tree round trip' ); # 1

sub tree {
	['Document', {},
		['head1', {}, 'Test page'],
		"\n\nThis is a test page showing some syntax:\n\n",
		['bold', {}, 'Bold text'], "\n",
		['italic', {}, 'Italic text'], "\n",
		['bold', {},
			'more bold and ',
			['italic', {}, 'Bold and Italic']
		], "\n",
	]
}
