use Test::Simple tests => 1;

use Zim;

my $txt = Zim::Page::File::_read_file('t/testpage.txt');

print STDERR "Warning: testpage seems empty\n" unless $txt =~ /\S/;
my @blocks = Zim::Formatter->text2blocks( $txt );
my $newtxt = Zim::Formatter->blocks2text( @blocks );

ok($txt eq $newtxt, 'formatter round trip');

unless ($txt eq $newtxt) {
	print STDERR "\n\n# Diff:\n";
	open DIFF, '| diff t/testpage.txt - 1>&2' or die $!;
	print DIFF $newtxt;
	close DIFF;
	print STDERR "# End of Diff\n\n";
}
 
