#!/usr/bin/perl

use Module::Build;

my $class = Module::Build->subclass(
	class => 'My::Builder',
	code => << 'EOC'

use strict;

sub ACTION_build {
	# copy share data and call parent
	my $self = shift;
	$self->{properties}{script_files} = ['bin/zim']; # Bug in M:B ?

	my $blib = $self->blib;
	for (@{$self->rscan_dir('share')}) {
		next if /\.zim\.history$/ or -d $_;
		my $to = $_;
		$to =~ s/_zim\.config$/.zim.config/;
		$self->copy_if_modified(
			from => $_,
			to   => File::Spec->catfile($blib, $to) );
	}
	$self->copy_if_modified(
		from => 'Changes',
		to   => File::Spec->catfile($blib, qw/share doc zim changelog.txt/ ) );
	
	$self->SUPER::ACTION_build(@_)
}

sub install_types { # Why O Why is this necessary ?
	my $self = shift;
	return 'share', $self->SUPER::install_types(@_);
}

sub ACTION_install {
	# define install path for share data and call parent
	my $self = shift;
	my $p = $self->{properties};
	unless (
		exists $p->{install_path}{share}
		or $p->{install_base}
	) {
		my $bindir = $self->install_destination('script');
		my @dirs = File::Spec->splitdir($bindir);
		pop @dirs; # 'bin'
		my $sharedir = File::Spec->catdir(@dirs, 'share', 'zim');
		$p->{install_path}{share} = $sharedir;
	}

	$self->SUPER::ACTION_install(@_)
}

sub install_base_relative { # define install base path for share data
	my ($self, $type) = @_;
	return File::Spec->catdir('share', 'zim') if $type eq 'share';
	$self->SUPER::install_base_relative($type);
}
EOC
);
    
my $build = $class->new(
	module_name => 'Zim',
	dist_author => 'Jaap Karssenberg <pardus@cpan.org>',
	license => 'perl',
	script_files => ['bin/zim'],
	requires => {
		'perl'           => '5.6.1',
		# I don't trust older versions to work
		'Gtk2'           => 0,
		'POSIX'          => 0,
		'Storable'       => 0,
		'File::Spec'     => 0,
		'File::BaseDir'  => 0,
		'File::MimeInfo' => 0,
	},
	#recommends => {},
	build_requires => {
		'Module::Build' => '0.24',
		'Test::More' => 0,
	},
	create_makefile_pl => 'passthrough',
	#dynamic_config => 1,
);

$build->create_build_script;

