package Zim;

use strict;
use POSIX qw(strftime);
use File::Spec;
use File::MimeInfo;

our $VERSION = 0.01;

sub new {
	my ($class, $dir) = @_;
	$dir = File::Spec->canonpath($dir);
	my $self = bless {root => $dir}, $class;
	
	# FIXME algo below is unwanted
	# we need some advandced caching for all this
	#$self->_scan_for_plugins($self->{root});

	return $self;
}

=cut

sub _scan_for_plugins {
	my ($self, $dir) = @_;
	return unless -d $dir;
	#print "scanning $dir\n";
	my $file = File::Spec->catfile($dir, '.zim.template');
	if (-f $file) {
		print "found $file\n";
		$file = _catfile($file);
		if ($file =~ /^module=(.+)$/m) {
			my $class = $1;
			eval "use $class";
			die if $@;
			my $page = $self->get_pagename($dir);
			$self->{plugins}{$page} = $class->new($dir);
			print "found plugin for namespace $page";
			return;
		}
	}
	opendir DIR, $dir or die "Could not list $dir\n";
	my @items = grep {! /^\./} sort readdir DIR;
	close DIR;
	for (@items) {
		my $subdir = File::Spec->catdir($dir, $_);
		$self->_scan_for_plugins($subdir) if -d $subdir;
	}
}

sub belongs_to_plugin {
	my ($self, $page) = @_;
	my ($plug) = grep {$page =~ /^$_:/} keys %{$self->{plugins}};
	return $plug;
}

=cut

sub list_pages {
	my ($self, $namespace, $callback) = @_;
	my $dir = File::Spec->catdir($self->{root}, split ':', $namespace);
	return unless -d $dir;
	unless ($callback) {
		my @pages;
		$callback = sub {push @pages, @_};
		_list_pages($dir, $namespace, $callback);
		return @pages;
	}
	else {  _list_pages($dir, $namespace, $callback)  }
}

sub _list_pages {
	my ($dir, $pref, $callback) = @_;
	my @pages;
	opendir DIR, $dir or die "Could not list $dir\n";
	my @items = grep {! /^\./} sort readdir DIR;
	closedir DIR;
	for (@items) {
		my $child = File::Spec->catdir($dir, $_);
		my $name  = length($pref) ? "$pref:$_" : $_;
		if (-d $child) {
			$name =~ s/_files$//;
			_list_pages($child, $name, $callback); # recurs
		}
		else {
			next unless mimetype($child) =~ /^text/;
			$name =~ s/\.txt//i;
			push @pages, $name;
		}
	}
	$callback->(@pages);
}

sub page_exists {
	my ($self, $page) = @_;
	
#	if (my $plug = $self->belongs_to_plugin($page)) {
#		$page =~ s/$plug://;
#		return $self->{plugins}{$plug}->page_exists($page);
#	}
	
	my $file = $self->get_filename($page);
	return -e $file;
}

sub load_page {
	my ($self, $page) = @_;

#	if (my $plug = $self->belongs_to_plugin($page)) {
#		$page =~ s/$plug://;
#		return $self->{plugins}{$plug}->load_page($page);
#	}
	
	my $file = $self->get_filename($page);
	my $text;
	if (-f $file and -e $file) { $text = _catfile($file) }
	else {
		$text = '====== '.$self->get_title($page). " ======\n" .
		        'Created '.strftime('%A %d/%m/%Y %H:%M', localtime) . "\n\n";
	}
	return Zim::Page->new($self, [$self->parse_text($text)]);
}

sub _catfile {
	my $file = shift;
	open TXT, $file or die "Could not read $file\n";
	binmode TXT, ':utf8' unless $] < 5.008;
	my $text = join '', <TXT>;
	close TXT;
	return $text;
}

sub save_page {
	my ($self, $page, $data) = @_;
	my ($file, $dir) = $self->get_filename($page);
	my $text = $self->parse_data( $data );
	if ($text =~ /\S/) {
		_mkdir($dir) unless -d $dir;
		open TXT, ">$file" or die "Could not write $file\n";
		binmode TXT, ':utf8' unless $] < 5.008;
		print TXT $text;
		close TXT or die "Could not write $file\n";
	}
	else {}
}

sub _rmdir_if_empty {
}

sub move_page {
}

sub get_filename { # this routine is used a lot, cna we optimize it?
	my ($self, $page) = @_;
	my @dirs = split ':', $page;
	my $file = pop @dirs;

	# check for any files that should have been dirs
	my $dir = File::Spec->catdir($self->{root}, @dirs);
	unless (-d $dir) {
		my $path = $self->{root};
		for (0 .. $#dirs) {
			$path = File::Spec->catdir($path, $dirs[$_]);
			last unless -e $path;
			$dirs[$_] .= '_files' if -f _;
		}
		$dir = File::Spec->catdir($self->{root}, @dirs);
	}

	# check which filename to use
	for ($file, "$file.txt", lc($file), lc($file).'.txt') {
		$file = File::Spec->catfile($dir, $_);
		last if -f $file;
	}
	#print "$page => $file\n";

	return wantarray ? ($file, $dir) : $file;
}

sub get_pagename {
	my ($self, $file) = @_;
	$file = File::Spec->canonpath($file);
	$file =~ s/^$self->{root}//
		or die "file $file outside root $self->{root}\n";
	$file =~ s/\.txt//i;
	my @parts = File::Spec->splitdir($file);
	my $page = join ':', @parts;
	$page =~ s/^://;
	return $page;
}

sub get_title {
	shift;
	my $page = shift;
	my @parts = split ':', $page;
	return join ':', map {ucfirst $_} @parts;
}

sub _mkdir {
	my ($vol, $dirs) = File::Spec->splitpath(shift(@_), 'NO_FILE');
	my @dirs = File::Spec->splitdir($dirs);
	my $path = File::Spec->catpath($vol, shift @dirs);
	mkdir $path or die "Could not create dir $path\n"
		if length $path and ! -e $path;
	while (@dirs) {
		$path = File::Spec->catdir($path, shift @dirs);
		mkdir $path or die "Could not create dir $path\n"
			unless -e $path;
	}
}

our @parse_subs = qw/parse_link parse_bold/;

sub parse_text {
	# split in headers and paragraphs
	# for headers it depends on the source whether they are
	# followed by a empty line or not, for paragraphs (normal,
	# pre, lists, etc.) we always append an extra line break
	my ($self, $text) = @_;
	return map {
		(! /\S/)        ?  undef                         :
		/^(\t|\s\s)/    ? ($self->parse_pre($_), "\n"  ) :
		/\n?^==+\s+\S+/ ? ($self->parse_head($_)       ) :
		                  ($self->parse_block($_), "\n") ;
	} split /(?:^\s*\n)+|(\n?^==+\s+\S.*\n(\s*\n)?)/m, $text;
}

sub parse_head {
	my ($self, $head) = @_;
	$head =~ s/^(==+)\s+(.*?)(?:\s+==+|\s*)(\n(?:\s*\n)?)/$2/;
	my $h = 7 - length($1); # =X6 => head1, =X5 => head2 etc.
	my $lb = (length($3) == 1) ? "\n" : "\n\n";
	return ["head$h" => $head], $lb;
}

sub parse_pre {
	my ($self, $pre) = @_;
	my ($indent) = ($pre =~ /^(\s+)/);
	$pre =~ s/^$indent//mg;
	return ['pre' => $pre];
}

sub parse_block {
	my ($self, @text) = @_;
	for my $sub (@parse_subs) {
		@text = map {ref($_) ? $_ : ($self->$sub($_))} @text;
	}
	return @text;
}

sub parse_link {
	my ($self, $text) = @_;
	my $i = 0;
	return map {
		if ($i++ % 2) {
			if (s/^\[\[(.+)\]\]$/$1/) {
				if (/^(.*)\|(.*)$/) { ['link', $2, $1] }
				else                { ['link', $_]     }
			}
			else { ['link', $_] }
		} else { $_ }
	} split /(\[\[.+?\]\]|\b\w+:\/\/\S+[^\s\,\.\;])/, $text;
}

sub parse_bold {
	my ($self, $text) = @_;
	my $i = 0;
	return	map { ($i++ % 2) ? ['bold', $_] : $_ }
		split /\*\*(.+?)\*\*/, $text;
}

sub parse_data { ## unknown tags just fall through as "normal" text
	my ($self, $data) = @_;
	my $text;
	while (my ($tag, @node) = $data->read_block) {
		#use Data::Dumper; print "$tag: ", Dumper \@node;
		last unless defined $tag;
		if ($tag eq 'link') { 
			@node = (@node > 1) ? ("[[$node[1]|$node[0]]]") :
				($node[0] =~ /^\w+:\/\//) ? ($node[0])  :
				                       ("[[$node[0]]]") ;
		}
		elsif ($tag eq 'bold') { $_ = "**$_**" for @node }
		elsif ($tag eq 'pre')  { s/^/    /mg   for @node }
		elsif ($tag =~ /^head(\d)$/) {
			my $n = 7 - $1;
			@node = map {('='x$n)." $_ ".('='x$n)} @node;
		}
		$text .= join '', @node;
	}
	$text =~ s/\n?$/\n/; # unix files should always end with \n
	return $text;
}

package Zim::Page;

sub new {
	my ($class, $parent, $data) = @_;
	my $self = bless {
		zim  => $parent,
		data => $data || [],
		iter => 0,
	}, $class;
	@{$self->{data}} = grep defined($_), @{$self->{data}};
	$self->clean if $data;
	return $self;
}

sub rewind { $_[0]->{iter} = 0 }

sub read_block {
	my $self = shift;
	return undef if $self->{iter} >= @{$self->{data}};

	my $data = $self->{data}[ $self->{iter}++ ];
	return ref($data) ? (@$data) : ('normal', $data);
}

sub push_block {
	my ($self, $tag, @node) = @_;
	if ($tag eq 'normal') {
		push @{$self->{data}}, @node;
	}
	else {
		push @{$self->{data}}, [$tag, @node];
	}
}

sub unshift_block {
	my ($self, $tag, @node) = @_;
	if ($tag eq 'normal') {
		unshift @{$self->{data}}, @node;
	}
	else {
		unshift @{$self->{data}}, [$tag, @node];
	}
}

sub clean {
	my $self = shift;
	for (0 .. $#{$self->{data}}) {
		unless (
			ref($self->{data}[$_])   or
			ref($self->{data}[$_-1])
		) {
			$self->{data}[$_] = $self->{data}[$_-1] . $self->{data}[$_];
			$self->{data}[$_-1] = undef;
		}
	}
	@{$self->{data}} = grep defined($_), @{$self->{data}};
}

sub clear {
	$_[0]->{data} = [];
	$_[0]->{iter} = 0;
}

1;
