#!/usr/bin/perl

use Module::Build;

my $class = Module::Build->subclass(
	class => 'My::Builder',
	code => << 'EOC'

use strict;

sub ACTION_build {
	# add share/ to install data and call parent
	my $self = shift;
	unless (defined $self->install_destination('share')) {
		my $bindir = $self->install_destination('script');
		my @dirs = File::Spec->splitdir($bindir);
		pop @dirs; # 'bin'
		my $sharedir = File::Spec->catdir(@dirs, 'share', 'zim');
		$self->{properties}{install_path}{share} = $sharedir;
	}
	
	my $blib = $self->blib;
	for (@{$self->rscan_dir('share')}) {
		next if -d $_;
		$self->copy_if_modified(
			from => $_,
			to   => File::Spec->catfile($blib, $_) );
	}
	$self->copy_if_modified(
		from => 'Changes',
		to   => File::Spec->catfile($blib, qw/share doc zim changelog.txt/ ) );
	
	$self->SUPER::ACTION_build(@_)
}

sub install_base_relative {
	my ($self, $type) = @_;
	return 'share' if $type eq 'share';
	$self->SUPER::install_base_relative($type);
}
EOC
);
    
my $build = $class->new(
	module_name => 'Zim',
	dist_author => 'Jaap Karssenberg <pardus@cpan.org>',
	license => 'perl',
	script_files => ['bin/zim'],
	requires => {
		'perl'           => '5.6.1',
		# I don't trust older versions to work
		'Gtk2'           => 0,
		'POSIX'          => 0,
		'File::Spec'     => 0,
		'File::BaseDir'  => 0,
		'File::MimeInfo' => 0,
	},
	#recommends => {},
	build_requires => {
		'Module::Build' => '0.24',
		#'Test::More' => 0,
	},
	create_makefile_pl => 'passthrough',
	#dynamic_config => 1,
);

$build->create_build_script;

